//AIM:Four point IDIF-FFT without using inbuilt Scilab FFT function
// (This is an extra solution)

//Computing four point IDFT for X(k)={10,-2+2j,-2,-2-2j} using Inverse
//Decimation in Frequency-Fast Fourier transform (i.e. IDIF-FFT )
//without using readymade inbuilt Scilab functions for IDFT/IFFT.

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let us begin with the programming.For understanding,let us write the given
//data as
//X(0)=10;X(1)=-2+2j,X(2)=-2,X(3)=-2-2j
X0_conj=10;//X0_conj means complex conjugate of X(O)
X1_conj=(-2)+((-1)*(2)*(sqrt(-1)));//X1_conj means complex conjugate of X(1)
X2_conj=-2;//X2_conj means complex conjugate of X(2)
X3_conj=(-2)-((-1)*(2)*(sqrt(-1)));//X3_conj means complex conjugate of X(3)
disp(X0_conj,'X*(0)=')
disp(X1_conj,'X*(1)=')
disp(X2_conj,'X*(2)=')
disp(X3_conj,'X*(3)=')
//Stage I computation
X0a=X2_conj+X0_conj;//Computing Stage-I output at line 1
disp(X0a,'Stage-I output at line 1')
X1b=(X3_conj+X1_conj);//Computing Stage-I output at line 2
disp(X1b,'Stage-I output at line 2')
X2c=(X2_conj-X0_conj)*(-1);//Computing Stage-I output at line 3
disp(X2c,'Stage-I output at line 3')
X3d=(X3_conj-X1_conj)*(-1);//Computing Stage-I output at line 4
disp(X3d,'Stage-I output at line 4')
//Stage II computation
X3d1=X3d*(-sqrt(-1));// Multiply by (-j) in the last line
disp(X3d1,'Stage-II input at the fourth line ')
x0_conj=X1b+X0a;//Computing stage-II output value at line 1
disp(x0_conj,'The stage-II output value at line 1=')
x2_conj=(X1b-X0a)*(-1);//Computing stage-II output value at line 2
disp(x2_conj,'The stage-II output value at line 2=')
x1_conj=X3d1+X2c;//Computing stage-II output value at line 3
disp(x1_conj,'The stage-II output value at line 3=')
x3_conj=(X3d1-X2c)*(-1);//Computing stage-II output value at line 4
disp(x3_conj,'The stage-II output value at line 4=')
//Now we will multiply stage-II output values individually with a factor of
// (1/N). Here N=4,So we will multiply by (1/4)
x0_conj_final=(1/4)*(x0_conj)
disp(x0_conj_final,'x*(0)=')
x2_conj_final=(1/4)*(x2_conj)
disp(x2_conj_final,'x*(2)=')
x1_conj_final=(1/4)*(x1_conj)
disp(x1_conj_final,'x*(1)=')
x3_conj_final=(1/4)*(x3_conj)
disp(x3_conj_final,'x*(3)=')
disp({,x0_conj_final,x1_conj_final,x2_conj_final,x3_conj_final,},'So,the IDFT of X(k) using Inverse Decimation-in-Frequency Fast Fourier Transform(IDIF-FFT) is x(n)=')

